# -*- coding: utf-8 -*-
"""Calorimétrie avec pertes thermiques



**Exercice 6 - Calorimétrie avec pertes thermiques**

Chargement des données
"""

# import des modules utiles pour le calcul numérique
import numpy as np
from matplotlib import pyplot as plt

# Données

# Date en secondes
dates = np.array([  0.,   2.,   4.,   6.,   8.,  10.,  12.,  14.,  16.,  18.,  20.,
        22.,  24.,  26.,  28.,  30.,  32.,  34.,  36.,  38.,  40.,  42.,
        44.,  46.,  48.,  50.,  52.,  54.,  56.,  58.,  60.,  62.,  64.,
        66.,  68.,  70.,  72.,  74.,  76.,  78.,  80.,  82.,  84.,  86.,
        88.,  90.,  92.,  94.,  96.,  98., 100., 102., 104., 106., 108.,
       110., 112., 114., 116., 118., 120., 122., 124., 126., 128., 130.,
       132., 134., 136., 138., 140., 142., 144., 146., 148., 150., 152.,
       154., 156., 158., 160., 162., 164., 166., 168., 170., 172., 174.,
       176., 178., 180., 182., 184., 186., 188., 190., 192., 194., 196.,
       198., 200., 202., 204., 206., 208., 210., 212., 214., 216., 218.,
       220., 222., 224., 226., 228., 230., 232., 234., 236., 238., 240.,
       242., 244., 246., 248., 250., 252., 254., 256., 258., 260., 262.,
       264., 266., 268., 270., 272., 274., 276., 278., 280., 282., 284.,
       286., 288., 290., 292., 294., 296., 298., 300., 302., 304., 306.,
       308., 310., 312., 314., 316., 318., 320., 322., 324., 326., 328.,
       330., 332., 334., 336., 338., 340., 342., 344., 346., 348., 350.,
       352., 354., 356., 358., 360., 362., 364., 366., 368., 370., 372.,
       374., 376., 378., 380., 382., 384., 386., 388., 390., 392., 394.,
       396., 398., 400., 402., 404., 406., 408., 410., 412., 414., 416.,
       418., 420., 422., 424., 426., 428., 430., 432., 434., 436., 438.,
       440., 442., 444., 446., 448., 450., 452., 454., 456., 458., 460.,
       462., 464., 466., 468., 470., 472., 474., 476., 478., 480., 482.,
       484., 486., 488., 490., 492., 494., 496., 498., 500., 502., 504.,
       506., 508., 510., 512., 514., 516., 518., 520., 522., 524., 526.,
       528., 530., 532., 534., 536., 538., 540., 542., 544., 546., 548.,
       550.])

# Températures en celsius
temperatures = np.array([23.31, 23.56, 23.75, 24.06, 24.19, 24.38, 24.56, 24.82, 24.94,
       25.07, 25.32, 25.57, 25.63, 26.07, 26.2 , 26.33, 26.39, 26.51,
       26.83, 27.02, 27.14, 27.39, 27.71, 27.83, 27.9 , 28.27, 28.46,
       28.59, 28.9 , 29.09, 29.28, 29.15, 29.47, 29.66, 29.91, 29.91,
       30.16, 30.22, 30.6 , 30.66, 30.79, 31.17, 31.17, 31.42, 31.48,
       31.73, 31.86, 32.11, 32.17, 32.49, 32.61, 32.74, 32.8 , 33.12,
       33.3 , 33.49, 33.62, 33.87, 33.93, 34.18, 34.25, 34.5 , 34.88,
       35.13, 35.25, 35.25, 35.57, 35.5 , 35.76, 35.94, 36.07, 36.45,
       36.51, 36.64, 36.95, 36.95, 37.39, 37.33, 37.58, 37.71, 37.89,
       38.27, 38.33, 38.4 , 38.59, 38.71, 38.77, 39.15, 39.28, 39.59,
       39.72, 39.72, 40.03, 40.09, 40.28, 40.22, 40.6 , 40.79, 40.72,
       41.04, 41.23, 41.35, 41.54, 41.79, 41.98, 42.17, 42.42, 42.48,
       42.61, 42.86, 42.92, 42.99, 43.43, 43.55, 43.62, 43.8 , 43.93,
       44.12, 44.31, 44.5 , 44.62, 44.75, 44.94, 45.  , 45.12, 45.31,
       45.44, 45.69, 45.69, 46.  , 46.13, 46.38, 46.57, 46.7 , 46.88,
       47.01, 47.2 , 47.26, 47.51, 47.51, 47.77, 48.02, 48.21, 48.33,
       48.58, 48.65, 48.65, 49.02, 49.02, 49.21, 49.27, 49.53, 49.65,
       49.97, 50.03, 50.09, 50.41, 50.53, 50.72, 50.97, 51.16, 51.29,
       51.29, 51.54, 51.66, 51.91, 51.98, 52.17, 52.42, 52.42, 52.54,
       52.67, 52.8 , 53.11, 53.24, 53.36, 53.55, 53.61, 53.93, 53.93,
       54.05, 54.3 , 54.43, 54.62, 54.93, 55.  , 55.31, 55.31, 55.37,
       55.75, 55.75, 55.75, 56.  , 56.19, 56.44, 56.44, 56.76, 56.88,
       57.01, 57.13, 57.26, 57.38, 57.51, 57.76, 57.82, 58.01, 58.08,
       58.33, 58.58, 58.45, 58.77, 59.02, 59.08, 59.27, 59.4 , 59.52,
       59.71, 59.84, 59.96, 60.28, 60.21, 60.53, 60.59, 60.91, 60.91,
       61.16, 61.16, 61.35, 61.6 , 61.66, 61.85, 61.91, 62.16, 62.35,
       62.6 , 62.6 , 62.73, 62.73, 62.98, 63.17, 63.29, 63.48, 63.48,
       63.67, 63.92, 63.8 , 64.18, 64.24, 64.68, 64.55, 64.74, 64.99,
       64.93, 65.24, 65.37, 65.5 , 65.56, 65.81, 65.81, 66.06, 66.19,
       66.25, 66.44, 66.63, 66.5 , 66.88, 67.  , 67.07, 67.13, 67.38,
       67.63, 67.44, 67.76, 67.95, 68.32, 68.32])

"""2. Tracé de la température en fonction du temps"""

plt.scatter(dates,temperatures,s=2)
plt.xlabel('t [s]')
plt.ylabel('T [°C]')
plt.title("Question 3-a")
plt.show()

"""3. Définition de la fonction extraire_pente"""

Text = 14 # °C

def extraire_pente(t,T):
    """
    Fonction qui prend en paramètre les dates t et les températures T, et renvoie
    les tableaux (Text-T) et dT/dt.
    La dérivée est estimée avec la limite moyenne, donc les points initial et final sont perdus
    et les tableaux renvoyés sont plus courts de 2 cases.
    """
    N = len(t)
    dT = Text - T[1:N-1]    # on enlève le premier et le dernier point pour le calcul de dérivée
    der = np.zeros(N-2)     # tableau contenant la dérivée
    for i in range(1,N-1):  # indices correspondant aux tableaux d'entrée t et T
        der[i-1] = (T[i+1] - T[i-1]) / (t[i+1] - t[i-1])  # der est décalé de 1
    return dT, der

"""Tracé de  $\dfrac{\rm d T}{\rm d t}$ en fonction de $(T_\rm{ext} - T)$."""

x,y = extraire_pente(dates,temperatures)
plt.figure()
plt.scatter(x,y,s=2)
plt.xlabel('Text-T [K]')
plt.ylabel('dT/dt [K/s]')
plt.title("Question 3-b")
plt.show()

"""4. On constate que les données sont trop bruitées pour faire une régression linéaire, on définit une fonction lissage pour réaliser une moyenne glissante pour lisser les données."""

def lissage(T,n_lissage):
    """
    Prend en paramètre un tableaux de températures et un nombre n de points, et
    renvoie un nouveau tableau contenant la moyenne glissante du premier sur n
    points.
    Le tableau renvoyé contient n points de moins que celui d'entrée.
    """
    N = len(T)
    n = n_lissage//2                        # on répartit les points de lissage
    N_lisse = N - n_lissage
    T_lisse = np.zeros(N_lisse)             # on prépare un tableau avec les nouvelles températures
    for i in range(n,N-n):                  # indices correspondant au tableau d'entrée T
        T_lisse[i-n] = (T[i-n:i+n]).mean()  # T_lisse est décalé de n
    return T_lisse

"""5. Application du lissage et tracé  de  $\dfrac{\rm{ d} T}{\rm{d} t}$ en fonction de $(T_\rm{ext} - T)$ sur les données lissées."""

n_lissage = 20

temperatures_lisse = lissage(temperatures,n_lissage)  # lissage sur 20 points : 10 avant et 10 après
dates_lisse = dates[n_lissage//2:-n_lissage//2]       # on ajuste le nombre de points de dates correspondant

x_lisse,y_lisse = extraire_pente(dates_lisse,temperatures_lisse)

plt.scatter(dates_lisse, temperatures_lisse,s=1)
plt.xlabel('t [s] lissé')
plt.ylabel('T [°C] lissé')
plt.title("Température mesurée lissée en fonction du temps")
plt.show()

plt.scatter(x_lisse,y_lisse,s=1)
plt.xlabel('Text-T [K] lissé')
plt.ylabel('dT/dt [K/s] lissé')
plt.title("Dérivée de la température issue de la température lissée en fonction de la température lissée")
plt.show()

"""6. Définition de la fonction mesureRC permettant d'extraire R et C par régression linéaire et application aux données."""

puissance_chauffe = 325   # watt

def mesureRC(t,T,P,n_lissage):
    """
    Prend les données expérimentales et un nombre n de points de lissage et
    estime R et C à partir d'une régression linéaire de dT/dt = f(Text-T)
    à partir des données lissées.
    """
    t_li = t[n_lissage//2:-n_lissage//2]
    T_li = lissage(T,n_lissage)
    x,y = extraire_pente(t_li,T_li)
    a,b = np.polyfit(x,y,1)   # régression linéaire
    R, C = b / (a*P), P / b
    return R,C

print(mesureRC(dates,temperatures,puissance_chauffe,n_lissage))  # affichage du résultat pour les données fournies

"""7. Utilisation d'une simulation Monte-Carlo pour simuler des jeux de données et estimer l'incertitude-type de la mesure. L'énoncé ne précisant pas la nature des précisions de mesure données, on utilise une distribution uniforme pour simuler la variabilité. """

delta_T, delta_P, delta_t = 0.3, 5, 1e-3
n_lissage, n_tirages = 20, 1000

R,C = np.zeros(n_tirages), np.zeros(n_tirages)  # on prépare des tableaux pour les résultats

N = len(dates)

for i in range(n_tirages):
    dates_fluct = dates + np.random.uniform(-delta_t,delta_t,N)                 # génération d'un jeu de données t
    temperatures_fluct = temperatures + np.random.uniform(-delta_T,delta_T,N)   # génération d'un jeu de données T
    puiss_fluct = puissance_chauffe + np.random.uniform(-delta_P,delta_P)                   # génération d'une valeur de P
    R[i],C[i] = mesureRC(dates_fluct, temperatures_fluct, puiss_fluct, n_lissage)


print("C = {:.3e} +/- {:.2e} J/K ({:.2f} %)".format(C.mean(), C.std(), 100*C.std()/C.mean()))
print("R = {:.3e} +/- {:.2e} K/W ({:.2f} %)".format(R.mean(), R.std(), 100*R.std()/R.mean()))
